/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.spout;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllParticleTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.api.behaviour.spouting.BlockSpoutingBehaviour;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.fluids.spout.FillingBySpout;
import com.zurrtum.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.particle.FluidParticleData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public class SpoutBlockEntity
extends SmartBlockEntity {
    public static final int FILLING_TIME = 20;
    protected BeltProcessingBehaviour beltProcessing;
    public int processingTicks = -1;
    public boolean sendSplash;
    public BlockSpoutingBehaviour customProcess;
    public SmartFluidTankBehaviour tank;
    private boolean createdSweetRoll;
    private boolean createdHoneyApple;
    private boolean createdChocolateBerries;
    protected static int SPLASH_PARTICLE_COUNT = 20;

    public SpoutBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.SPOUT, pos, state);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1012(0.0, -2.0, 0.0);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.tank = SmartFluidTankBehaviour.single(this, 81000, (TriFunction<SmartFluidTankBehaviour, Boolean, Optional<Integer>, SmartFluidTankBehaviour.InternalFluidHandler>)((TriFunction)SpoutFluidHandler::new));
        behaviours.add(this.tank);
        this.beltProcessing = new BeltProcessingBehaviour(this).whenItemEnters(this::onItemReceived).whileItemHeld(this::whenItemHeld);
        behaviours.add(this.beltProcessing);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.SPOUT, AllAdvancements.FOODS);
    }

    protected BeltProcessingBehaviour.ProcessingResult onItemReceived(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (handler.blockEntity.isVirtual()) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (!FillingBySpout.canItemBeFilled(this.field_11863, transported.stack)) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.tank.isEmpty()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (FillingBySpout.getRequiredAmountForItem((class_3218)this.field_11863, transported.stack, this.getCurrentFluidInTank()) == -1) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    protected BeltProcessingBehaviour.ProcessingResult whenItemHeld(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (this.processingTicks != -1 && this.processingTicks != 5) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (!FillingBySpout.canItemBeFilled(this.field_11863, transported.stack)) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.tank.isEmpty()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        FluidStack fluid = this.getCurrentFluidInTank();
        int requiredAmountForItem = FillingBySpout.getRequiredAmountForItem((class_3218)this.field_11863, transported.stack, fluid.copy());
        if (requiredAmountForItem <= 0) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (requiredAmountForItem > fluid.getAmount()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (this.processingTicks == -1) {
            this.processingTicks = 20;
            this.notifyUpdate();
            AllSoundEvents.SPOUTING.playOnServer(this.field_11863, (class_2382)this.field_11867, 0.75f, 0.9f + 0.2f * (float)Math.random());
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        class_1799 out = FillingBySpout.fillItem((class_3218)this.field_11863, requiredAmountForItem, transported.stack, fluid);
        if (!out.method_7960()) {
            transported.clearFanProcessingData();
            ArrayList<TransportedItemStack> outList = new ArrayList<TransportedItemStack>();
            TransportedItemStack held = null;
            TransportedItemStack result = transported.copy();
            result.stack = out;
            if (!transported.stack.method_7960()) {
                held = transported.copy();
            }
            outList.add(result);
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(outList, held));
        }
        this.award(AllAdvancements.SPOUT);
        if (this.trackFoods()) {
            this.createdChocolateBerries |= out.method_31574(AllItems.CHOCOLATE_BERRIES);
            this.createdHoneyApple |= out.method_31574(AllItems.HONEYED_APPLE);
            this.createdSweetRoll |= out.method_31574(AllItems.SWEET_ROLL);
            if (this.createdChocolateBerries && this.createdHoneyApple && this.createdSweetRoll) {
                this.award(AllAdvancements.FOODS);
            }
        }
        SmartFluidTankBehaviour.TankSegment primaryHandler = this.tank.getPrimaryHandler();
        primaryHandler.setFluid(fluid);
        primaryHandler.markDirty();
        this.sendSplash = true;
        this.notifyUpdate();
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    private FluidStack getCurrentFluidInTank() {
        return this.tank.getPrimaryHandler().getFluid();
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71465("ProcessingTicks", this.processingTicks);
        if (this.sendSplash && clientPacket) {
            view.method_71472("Splash", true);
            this.sendSplash = false;
        }
        if (!this.trackFoods()) {
            return;
        }
        if (this.createdChocolateBerries) {
            view.method_71472("ChocolateBerries", true);
        }
        if (this.createdHoneyApple) {
            view.method_71472("HoneyApple", true);
        }
        if (this.createdSweetRoll) {
            view.method_71472("SweetRoll", true);
        }
    }

    private boolean trackFoods() {
        AdvancementBehaviour behaviour = this.getBehaviour(AdvancementBehaviour.TYPE);
        return behaviour != null && behaviour.isOwnerPresent();
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.processingTicks = view.method_71424("ProcessingTicks", 0);
        this.createdChocolateBerries = view.method_71433("ChocolateBerries", false);
        this.createdHoneyApple = view.method_71433("HoneyApple", false);
        this.createdSweetRoll = view.method_71433("SweetRoll", false);
        if (!clientPacket) {
            return;
        }
        if (view.method_71433("Splash", false)) {
            this.spawnSplash(this.tank.getPrimaryTank().getRenderedFluid());
        }
    }

    @Override
    public void tick() {
        class_2338 filling;
        BlockSpoutingBehaviour behavior;
        super.tick();
        FluidStack currentFluidInTank = this.getCurrentFluidInTank();
        if (!(this.processingTicks != -1 || !this.isVirtual() && this.field_11863.method_8608() || currentFluidInTank.isEmpty() || (behavior = BlockSpoutingBehaviour.get(this.field_11863, filling = this.field_11867.method_10087(2))) == null || behavior.fillBlock(this.field_11863, filling, this, currentFluidInTank.copy(), true) <= 0)) {
            this.processingTicks = 20;
            this.customProcess = behavior;
            this.notifyUpdate();
        }
        if (this.processingTicks >= 0) {
            --this.processingTicks;
            if (this.processingTicks == 5 && this.customProcess != null) {
                int fillBlock = this.customProcess.fillBlock(this.field_11863, this.field_11867.method_10087(2), this, currentFluidInTank.copy(), false);
                this.customProcess = null;
                if (fillBlock > 0) {
                    SmartFluidTankBehaviour.TankSegment handler = this.tank.getPrimaryHandler();
                    handler.setFluid(FluidHelper.copyStackWithAmount(currentFluidInTank, currentFluidInTank.getAmount() - fillBlock));
                    handler.markDirty();
                    this.sendSplash = true;
                    this.notifyUpdate();
                }
            }
        }
        if (this.processingTicks >= 8 && this.field_11863.method_8608()) {
            this.spawnProcessingParticles(this.tank.getPrimaryTank().getRenderedFluid());
        }
    }

    protected void spawnProcessingParticles(FluidStack fluid) {
        if (this.isVirtual() || fluid.isEmpty()) {
            return;
        }
        class_243 vec = VecHelper.getCenterOf((class_2382)this.field_11867);
        vec = vec.method_1023(0.0, 0.5, 0.0);
        FluidParticleData particle = new FluidParticleData(AllParticleTypes.FLUID_PARTICLE, fluid.getFluid(), fluid.getComponentChanges());
        this.field_11863.method_8494((class_2394)particle, vec.field_1352, vec.field_1351, vec.field_1350, 0.0, (double)-0.1f, 0.0);
    }

    protected void spawnSplash(FluidStack fluid) {
        if (this.isVirtual() || fluid.isEmpty()) {
            return;
        }
        class_243 vec = VecHelper.getCenterOf((class_2382)this.field_11867);
        vec = vec.method_1023(0.0, 1.6875, 0.0);
        FluidParticleData particle = new FluidParticleData(AllParticleTypes.FLUID_PARTICLE, fluid.getFluid(), fluid.getComponentChanges());
        for (int i = 0; i < SPLASH_PARTICLE_COUNT; ++i) {
            class_243 m = VecHelper.offsetRandomly(class_243.field_1353, this.field_11863.field_9229, 0.125f);
            m = new class_243(m.field_1352, Math.abs(m.field_1351), m.field_1350);
            this.field_11863.method_8494((class_2394)particle, vec.field_1352, vec.field_1351, vec.field_1350, m.field_1352, m.field_1351, m.field_1350);
        }
    }

    public static class SpoutFluidHandler
    extends SmartFluidTankBehaviour.InternalFluidHandler {
        private static final int[] EMPTY_SLOTS = new int[0];

        public SpoutFluidHandler(SmartFluidTankBehaviour behaviour, boolean enforceVariety, Optional<Integer> max) {
            super(behaviour, enforceVariety, max);
        }

        @Override
        public int[] getAvailableSlots(@Nullable class_2350 side) {
            if (side == class_2350.field_11033) {
                return EMPTY_SLOTS;
            }
            return super.getAvailableSlots(side);
        }
    }
}

