/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.transfer;

import com.google.common.base.Predicates;
import com.zurrtum.create.AllFluidTags;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.packet.s2c.FluidSplashPacket;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;

public abstract class FluidManipulationBehaviour
extends BlockEntityBehaviour<SmartBlockEntity> {
    class_3341 affectedArea;
    class_2338 rootPos;
    boolean infinite;
    protected boolean counterpartActed;
    static final int searchedPerTick = 1024;
    static final int validationTimerMin = 160;
    List<BlockPosEntry> frontier;
    Set<class_2338> visited;
    int revalidateIn;

    public FluidManipulationBehaviour(SmartBlockEntity be) {
        super(be);
        this.setValidationTimer();
        this.infinite = false;
        this.visited = new HashSet<class_2338>();
        this.frontier = new ArrayList<BlockPosEntry>();
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    public void counterpartActed() {
        this.counterpartActed = true;
    }

    protected int validationTimer() {
        int maxBlocks = this.maxBlocks();
        return maxBlocks < 0 ? 160 : Math.max(160, maxBlocks / 1024 + 1);
    }

    protected int setValidationTimer() {
        this.revalidateIn = this.validationTimer();
        return this.revalidateIn;
    }

    protected int setLongValidationTimer() {
        this.revalidateIn = this.validationTimer() * 2;
        return this.revalidateIn;
    }

    protected int maxRange() {
        return (Integer)AllConfigs.server().fluids.hosePulleyRange.get();
    }

    protected int maxBlocks() {
        return (Integer)AllConfigs.server().fluids.hosePulleyBlockThreshold.get();
    }

    protected boolean fillInfinite() {
        return (Boolean)AllConfigs.server().fluids.fillInfinite.get();
    }

    public void reset() {
        if (this.affectedArea != null) {
            this.scheduleUpdatesInAffectedArea();
        }
        this.affectedArea = null;
        this.setValidationTimer();
        this.frontier.clear();
        this.visited.clear();
        this.infinite = false;
    }

    @Override
    public void destroy() {
        this.reset();
        super.destroy();
    }

    protected void scheduleUpdatesInAffectedArea() {
        class_1937 world = this.getWorld();
        class_2338.method_20437((class_2338)new class_2338(this.affectedArea.method_35415() - 1, this.affectedArea.method_35416() - 1, this.affectedArea.method_35417() - 1), (class_2338)new class_2338(this.affectedArea.method_35418() + 1, this.affectedArea.method_35419() + 1, this.affectedArea.method_35420() + 1)).forEach(pos -> {
            class_3610 nextFluidState = world.method_8316(pos);
            if (nextFluidState.method_15769()) {
                return;
            }
            world.method_64312(pos, nextFluidState.method_15772(), world.method_8409().method_43048(5));
        });
    }

    protected int comparePositions(BlockPosEntry e1, BlockPosEntry e2) {
        class_243 centerOfRoot = VecHelper.getCenterOf((class_2382)this.rootPos);
        class_2338 pos2 = e2.pos;
        class_2338 pos1 = e1.pos;
        if (pos1.method_10264() != pos2.method_10264()) {
            return Integer.compare(pos2.method_10264(), pos1.method_10264());
        }
        int compareDistance = Integer.compare(e2.distance, e1.distance);
        if (compareDistance != 0) {
            return compareDistance;
        }
        return Double.compare(VecHelper.getCenterOf((class_2382)pos2).method_1025(centerOfRoot), VecHelper.getCenterOf((class_2382)pos1).method_1025(centerOfRoot));
    }

    protected class_3611 search(class_3611 fluid, List<BlockPosEntry> frontier, Set<class_2338> visited, BiConsumer<class_2338, Integer> add, boolean searchDownward) throws ChunkNotLoadedException {
        class_1937 world = this.getWorld();
        int maxBlocks = this.maxBlocks();
        int maxRange = this.maxRange();
        int maxRangeSq = maxRange * maxRange;
        for (int i = 0; !(i >= 1024 || frontier.isEmpty() || visited.size() > maxBlocks && this.canDrainInfinitely(fluid)); ++i) {
            BlockPosEntry entry = frontier.remove(0);
            class_2338 currentPos = entry.pos;
            if (visited.contains(currentPos)) continue;
            visited.add(currentPos);
            if (!world.method_8477(currentPos)) {
                throw new ChunkNotLoadedException();
            }
            class_3610 fluidState = world.method_8316(currentPos);
            if (fluidState.method_15769()) continue;
            class_3611 currentFluid = FluidHelper.convertToStill(fluidState.method_15772());
            if (fluid == null) {
                fluid = currentFluid;
            }
            if (!currentFluid.method_15780(fluid)) continue;
            add.accept(currentPos, entry.distance);
            for (class_2350 side : Iterate.directions) {
                class_3611 nextFluid;
                class_3610 nextFluidState;
                if (!searchDownward && side == class_2350.field_11033) continue;
                class_2338 offsetPos = currentPos.method_10093(side);
                if (!world.method_8477(offsetPos)) {
                    throw new ChunkNotLoadedException();
                }
                if (visited.contains(offsetPos) || offsetPos.method_10262((class_2382)this.rootPos) > (double)maxRangeSq || (nextFluidState = world.method_8316(offsetPos)).method_15769() || (nextFluid = nextFluidState.method_15772()) == FluidHelper.convertToFlowing(nextFluid) && side == class_2350.field_11036 && !VecHelper.onSameAxis(this.rootPos, offsetPos, class_2350.class_2351.field_11052)) continue;
                frontier.add(new BlockPosEntry(offsetPos, entry.distance + 1));
            }
        }
        return fluid;
    }

    protected void playEffect(class_1937 world, class_2338 pos, class_3611 fluid, boolean fillSound) {
        if (fluid == null) {
            return;
        }
        class_2338 splooshPos = pos == null ? this.blockEntity.method_11016() : pos;
        FluidStack stack = new FluidStack(fluid, 1);
        class_3414 soundevent = fillSound ? FluidHelper.getFillSound(stack) : FluidHelper.getEmptySound(stack);
        world.method_8396(null, splooshPos, soundevent, class_3419.field_15245, 0.3f, 1.0f);
        if (world instanceof class_3218) {
            class_3218 serverLevel = (class_3218)world;
            serverLevel.method_8503().method_3760().method_14605(null, (double)splooshPos.method_10263(), (double)splooshPos.method_10264(), (double)splooshPos.method_10260(), 10.0, serverLevel.method_27983(), (class_2596)new FluidSplashPacket(splooshPos, stack.getFluid()));
        }
    }

    protected boolean canDrainInfinitely(class_3611 fluid) {
        if (fluid == null) {
            return false;
        }
        return this.maxBlocks() != -1 && ((BottomlessFluidMode)AllConfigs.server().fluids.bottomlessFluidMode.get()).test(fluid);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        if (this.infinite) {
            view.method_71472("Infinite", true);
        }
        if (this.rootPos != null) {
            view.method_71468("LastPos", class_2338.field_25064, (Object)this.rootPos);
        }
        if (this.affectedArea != null) {
            view.method_71468("AffectedAreaFrom", class_2338.field_25064, (Object)new class_2338(this.affectedArea.method_35415(), this.affectedArea.method_35416(), this.affectedArea.method_35417()));
            view.method_71468("AffectedAreaTo", class_2338.field_25064, (Object)new class_2338(this.affectedArea.method_35418(), this.affectedArea.method_35419(), this.affectedArea.method_35420()));
        }
        super.write(view, clientPacket);
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        this.infinite = view.method_71433("Infinite", false);
        this.rootPos = view.method_71426("LastPos", class_2338.field_25064).orElse(null);
        view.method_71426("AffectedAreaFrom", class_2338.field_25064).ifPresent(from -> view.method_71426("AffectedAreaTo", class_2338.field_25064).ifPresent(to -> {
            this.affectedArea = class_3341.method_34390((class_2382)from, (class_2382)to);
        }));
        super.read(view, clientPacket);
    }

    public record BlockPosEntry(class_2338 pos, int distance) {
    }

    public static class ChunkNotLoadedException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static enum BottomlessFluidMode implements Predicate<class_3611>
    {
        ALLOW_ALL((Predicate<class_3611>)Predicates.alwaysTrue()),
        DENY_ALL((Predicate<class_3611>)Predicates.alwaysFalse()),
        ALLOW_BY_TAG(fluid -> fluid.method_15791(AllFluidTags.BOTTOMLESS_ALLOW)),
        DENY_BY_TAG(fluid -> !fluid.method_15791(AllFluidTags.BOTTOMLESS_DENY));

        private final Predicate<class_3611> predicate;

        private BottomlessFluidMode(Predicate<class_3611> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean test(class_3611 fluid) {
            return this.predicate.test(fluid);
        }
    }
}

