/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.kinetics.base.DirectionalShaftHalvesBlockEntity;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.chainDrive.ChainDriveBlock;
import com.zurrtum.create.content.kinetics.gearbox.GearboxBlockEntity;
import com.zurrtum.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.ICogWheel;
import com.zurrtum.create.content.kinetics.speedController.SpeedControllerBlock;
import com.zurrtum.create.content.kinetics.speedController.SpeedControllerBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.SplitShaftBlockEntity;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4538;

public class RotationPropagator {
    private static final int MAX_FLICKER_SCORE = 128;

    private static float getRotationSpeedModifier(KineticBlockEntity from, KineticBlockEntity to) {
        boolean connectedByGears;
        IRotate definitionFrom;
        class_2248 toBlock;
        class_2248 fromBlock;
        class_2680 stateTo;
        class_2680 stateFrom;
        block17: {
            block16: {
                stateFrom = from.method_11010();
                stateTo = to.method_11010();
                fromBlock = stateFrom.method_26204();
                toBlock = stateTo.method_26204();
                if (!(fromBlock instanceof IRotate)) break block16;
                definitionFrom = (IRotate)fromBlock;
                if (toBlock instanceof IRotate) break block17;
            }
            return 0.0f;
        }
        IRotate definitionTo = (IRotate)toBlock;
        class_2338 diff = to.method_11016().method_10059((class_2382)from.method_11016());
        class_2350 direction = class_2350.method_10147((float)diff.method_10263(), (float)diff.method_10264(), (float)diff.method_10260());
        class_1937 world = from.method_10997();
        boolean alignedAxes = true;
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            if (axis == direction.method_10166() || axis.method_10173(diff.method_10263(), diff.method_10264(), diff.method_10260()) == 0) continue;
            alignedAxes = false;
        }
        boolean connectedByAxis = alignedAxes && definitionFrom.hasShaftTowards((class_4538)world, from.method_11016(), stateFrom, direction) && definitionTo.hasShaftTowards((class_4538)world, to.method_11016(), stateTo, direction.method_10153());
        float custom = from.propagateRotationTo(to, stateFrom, stateTo, diff, connectedByAxis, connectedByGears = ICogWheel.isSmallCog(stateFrom) && ICogWheel.isSmallCog(stateTo));
        if (custom != 0.0f) {
            return custom;
        }
        if (connectedByAxis) {
            float axisModifier = RotationPropagator.getAxisModifier(to, direction.method_10153());
            if (axisModifier != 0.0f) {
                axisModifier = 1.0f / axisModifier;
            }
            return RotationPropagator.getAxisModifier(from, direction) * axisModifier;
        }
        if (fromBlock instanceof ChainDriveBlock && toBlock instanceof ChainDriveBlock) {
            boolean connected = ChainDriveBlock.areBlocksConnected(stateFrom, stateTo, direction);
            return connected ? ChainDriveBlock.getRotationSpeedModifier(from, to) : 0.0f;
        }
        if (RotationPropagator.isLargeToLargeGear(stateFrom, stateTo, diff)) {
            class_2350.class_2351 sourceAxis = (class_2350.class_2351)stateFrom.method_11654((class_2769)class_2741.field_12496);
            class_2350.class_2351 targetAxis = (class_2350.class_2351)stateTo.method_11654((class_2769)class_2741.field_12496);
            int sourceAxisDiff = sourceAxis.method_10173(diff.method_10263(), diff.method_10264(), diff.method_10260());
            int targetAxisDiff = targetAxis.method_10173(diff.method_10263(), diff.method_10264(), diff.method_10260());
            return sourceAxisDiff > 0 ^ targetAxisDiff > 0 ? -1.0f : 1.0f;
        }
        if (ICogWheel.isLargeCog(stateFrom) && ICogWheel.isSmallCog(stateTo) && RotationPropagator.isLargeToSmallCog(stateFrom, stateTo, definitionTo, diff)) {
            return -2.0f;
        }
        if (ICogWheel.isLargeCog(stateTo) && ICogWheel.isSmallCog(stateFrom) && RotationPropagator.isLargeToSmallCog(stateTo, stateFrom, definitionFrom, diff)) {
            return -0.5f;
        }
        if (connectedByGears) {
            if (diff.method_19455(class_2338.field_11176) != 1) {
                return 0.0f;
            }
            if (ICogWheel.isLargeCog(stateTo)) {
                return 0.0f;
            }
            if (direction.method_10166() == definitionFrom.getRotationAxis(stateFrom)) {
                return 0.0f;
            }
            if (definitionFrom.getRotationAxis(stateFrom) == definitionTo.getRotationAxis(stateTo)) {
                return -1.0f;
            }
        }
        return 0.0f;
    }

    private static float getConveyedSpeed(KineticBlockEntity from, KineticBlockEntity to) {
        class_2680 stateTo;
        class_2680 stateFrom = from.method_11010();
        if (RotationPropagator.isLargeCogToSpeedController(stateFrom, stateTo = to.method_11010(), to.method_11016().method_10059((class_2382)from.method_11016()))) {
            return SpeedControllerBlockEntity.getConveyedSpeed(from, to, true);
        }
        if (RotationPropagator.isLargeCogToSpeedController(stateTo, stateFrom, from.method_11016().method_10059((class_2382)to.method_11016()))) {
            return SpeedControllerBlockEntity.getConveyedSpeed(to, from, false);
        }
        float rotationSpeedModifier = RotationPropagator.getRotationSpeedModifier(from, to);
        return from.getTheoreticalSpeed() * rotationSpeedModifier;
    }

    private static boolean isLargeToLargeGear(class_2680 from, class_2680 to, class_2338 diff) {
        class_2350.class_2351 toAxis;
        if (!ICogWheel.isLargeCog(from) || !ICogWheel.isLargeCog(to)) {
            return false;
        }
        class_2350.class_2351 fromAxis = (class_2350.class_2351)from.method_11654((class_2769)class_2741.field_12496);
        if (fromAxis == (toAxis = (class_2350.class_2351)to.method_11654((class_2769)class_2741.field_12496))) {
            return false;
        }
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            int axisDiff = axis.method_10173(diff.method_10263(), diff.method_10264(), diff.method_10260());
            if (!(axis == fromAxis || axis == toAxis ? axisDiff == 0 : axisDiff != 0)) continue;
            return false;
        }
        return true;
    }

    private static float getAxisModifier(KineticBlockEntity be, class_2350 direction) {
        if (!be.hasSource() && !be.isSource() || !(be instanceof DirectionalShaftHalvesBlockEntity)) {
            return 1.0f;
        }
        class_2350 source = ((DirectionalShaftHalvesBlockEntity)be).getSourceFacing();
        if (be instanceof GearboxBlockEntity) {
            return direction.method_10166() == source.method_10166() ? (direction == source ? 1.0f : -1.0f) : (direction.method_10171() == source.method_10171() ? -1.0f : 1.0f);
        }
        if (be instanceof SplitShaftBlockEntity) {
            return ((SplitShaftBlockEntity)be).getRotationSpeedModifier(direction);
        }
        return 1.0f;
    }

    private static boolean isLargeToSmallCog(class_2680 from, class_2680 to, IRotate defTo, class_2338 diff) {
        class_2350.class_2351 axisFrom = (class_2350.class_2351)from.method_11654((class_2769)class_2741.field_12496);
        if (axisFrom != defTo.getRotationAxis(to)) {
            return false;
        }
        if (axisFrom.method_10173(diff.method_10263(), diff.method_10264(), diff.method_10260()) != 0) {
            return false;
        }
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            if (axis == axisFrom || Math.abs(axis.method_10173(diff.method_10263(), diff.method_10264(), diff.method_10260())) == 1) continue;
            return false;
        }
        return true;
    }

    private static boolean isLargeCogToSpeedController(class_2680 from, class_2680 to, class_2338 diff) {
        if (!ICogWheel.isLargeCog(from) || !to.method_27852((class_2248)AllBlocks.ROTATION_SPEED_CONTROLLER)) {
            return false;
        }
        if (!diff.equals((Object)class_2338.field_10980.method_10074())) {
            return false;
        }
        class_2350.class_2351 axis = (class_2350.class_2351)from.method_11654((class_2769)CogWheelBlock.AXIS);
        if (axis.method_10178()) {
            return false;
        }
        return to.method_11654((class_2769)SpeedControllerBlock.HORIZONTAL_AXIS) != axis;
    }

    public static void handleAdded(class_1937 worldIn, class_2338 pos, KineticBlockEntity addedTE) {
        if (worldIn.method_8608()) {
            return;
        }
        if (!worldIn.method_8477(pos)) {
            return;
        }
        RotationPropagator.propagateNewSource(addedTE);
    }

    private static void propagateNewSource(KineticBlockEntity currentTE) {
        class_2338 pos = currentTE.method_11016();
        class_1937 world = currentTE.method_10997();
        for (KineticBlockEntity neighbourTE : RotationPropagator.getConnectedNeighbours(currentTE)) {
            float prevSpeed;
            boolean speedChangedTooOften;
            float speedOfCurrent = currentTE.getTheoreticalSpeed();
            float speedOfNeighbour = neighbourTE.getTheoreticalSpeed();
            float newSpeed = RotationPropagator.getConveyedSpeed(currentTE, neighbourTE);
            float oppositeSpeed = RotationPropagator.getConveyedSpeed(neighbourTE, currentTE);
            if (newSpeed == 0.0f && oppositeSpeed == 0.0f) continue;
            boolean incompatible = Math.signum(newSpeed) != Math.signum(speedOfNeighbour) && newSpeed != 0.0f && speedOfNeighbour != 0.0f;
            boolean tooFast = Math.abs(newSpeed) > (float)((Integer)AllConfigs.server().kinetics.maxRotationSpeed.get()).intValue() || Math.abs(oppositeSpeed) > (float)((Integer)AllConfigs.server().kinetics.maxRotationSpeed.get()).intValue();
            boolean bl = speedChangedTooOften = currentTE.getFlickerScore() > 128;
            if (tooFast || speedChangedTooOften) {
                world.method_22352(pos, true);
                return;
            }
            if (incompatible) {
                world.method_22352(pos, true);
                return;
            }
            if (Math.abs(oppositeSpeed) > Math.abs(speedOfCurrent)) {
                prevSpeed = currentTE.getSpeed();
                currentTE.setSource(neighbourTE.method_11016());
                currentTE.setSpeed(RotationPropagator.getConveyedSpeed(neighbourTE, currentTE));
                currentTE.onSpeedChanged(prevSpeed);
                currentTE.sendData();
                RotationPropagator.propagateNewSource(currentTE);
                return;
            }
            if (Math.abs(newSpeed) >= Math.abs(speedOfNeighbour)) {
                if (!currentTE.hasNetwork() || currentTE.network.equals(neighbourTE.network)) {
                    float epsilon = Math.abs(speedOfNeighbour) / 256.0f / 256.0f;
                    if (!(Math.abs(newSpeed) > Math.abs(speedOfNeighbour) + epsilon)) continue;
                    world.method_22352(pos, true);
                    continue;
                }
                if (currentTE.hasSource() && currentTE.source.equals((Object)neighbourTE.method_11016())) {
                    currentTE.removeSource();
                }
                prevSpeed = neighbourTE.getSpeed();
                neighbourTE.setSource(currentTE.method_11016());
                neighbourTE.setSpeed(RotationPropagator.getConveyedSpeed(currentTE, neighbourTE));
                neighbourTE.onSpeedChanged(prevSpeed);
                neighbourTE.sendData();
                RotationPropagator.propagateNewSource(neighbourTE);
                continue;
            }
            if (Math.abs(neighbourTE.getTheoreticalSpeed() - newSpeed) <= 1.0E-5f) continue;
            prevSpeed = neighbourTE.getSpeed();
            neighbourTE.setSpeed(newSpeed);
            neighbourTE.setSource(currentTE.method_11016());
            neighbourTE.onSpeedChanged(prevSpeed);
            neighbourTE.sendData();
            RotationPropagator.propagateNewSource(neighbourTE);
        }
    }

    public static void handleRemoved(class_1937 worldIn, class_2338 pos, KineticBlockEntity removedBE) {
        if (worldIn.method_8608()) {
            return;
        }
        if (removedBE == null) {
            return;
        }
        if (removedBE.getTheoreticalSpeed() == 0.0f) {
            return;
        }
        for (class_2338 neighbourPos : RotationPropagator.getPotentialNeighbourLocations(removedBE)) {
            KineticBlockEntity neighbourBE;
            class_2586 blockEntity;
            class_2680 neighbourState = worldIn.method_8320(neighbourPos);
            if (!(neighbourState.method_26204() instanceof IRotate) || !((blockEntity = worldIn.method_8321(neighbourPos)) instanceof KineticBlockEntity) || !(neighbourBE = (KineticBlockEntity)blockEntity).hasSource() || !neighbourBE.source.equals((Object)pos)) continue;
            RotationPropagator.propagateMissingSource(neighbourBE);
        }
    }

    private static void propagateMissingSource(KineticBlockEntity updateTE) {
        class_2338 missingSource;
        class_1937 world = updateTE.method_10997();
        LinkedList<KineticBlockEntity> potentialNewSources = new LinkedList<KineticBlockEntity>();
        LinkedList<class_2338> frontier = new LinkedList<class_2338>();
        frontier.add(updateTE.method_11016());
        class_2338 class_23382 = missingSource = updateTE.hasSource() ? updateTE.source : null;
        while (!frontier.isEmpty()) {
            class_2338 pos = (class_2338)frontier.remove(0);
            class_2586 blockEntity = world.method_8321(pos);
            if (!(blockEntity instanceof KineticBlockEntity)) continue;
            KineticBlockEntity currentBE = (KineticBlockEntity)blockEntity;
            currentBE.removeSource();
            currentBE.sendData();
            for (KineticBlockEntity neighbourBE : RotationPropagator.getConnectedNeighbours(currentBE)) {
                if (neighbourBE.method_11016().equals((Object)missingSource) || !neighbourBE.hasSource()) continue;
                if (!neighbourBE.source.equals((Object)pos)) {
                    potentialNewSources.add(neighbourBE);
                    continue;
                }
                if (neighbourBE.isSource()) {
                    potentialNewSources.add(neighbourBE);
                }
                frontier.add(neighbourBE.method_11016());
            }
        }
        for (KineticBlockEntity newSource : potentialNewSources) {
            if (!newSource.hasSource() && !newSource.isSource()) continue;
            RotationPropagator.propagateNewSource(newSource);
            return;
        }
    }

    private static KineticBlockEntity findConnectedNeighbour(KineticBlockEntity currentTE, class_2338 neighbourPos) {
        class_2680 neighbourState = currentTE.method_10997().method_8320(neighbourPos);
        if (!(neighbourState.method_26204() instanceof IRotate)) {
            return null;
        }
        if (!neighbourState.method_31709()) {
            return null;
        }
        class_2586 neighbourBE = currentTE.method_10997().method_8321(neighbourPos);
        if (!(neighbourBE instanceof KineticBlockEntity)) {
            return null;
        }
        KineticBlockEntity neighbourKBE = (KineticBlockEntity)neighbourBE;
        if (!(neighbourKBE.method_11010().method_26204() instanceof IRotate)) {
            return null;
        }
        if (!RotationPropagator.isConnected(currentTE, neighbourKBE) && !RotationPropagator.isConnected(neighbourKBE, currentTE)) {
            return null;
        }
        return neighbourKBE;
    }

    public static boolean isConnected(KineticBlockEntity from, KineticBlockEntity to) {
        class_2680 stateTo;
        class_2680 stateFrom = from.method_11010();
        return RotationPropagator.isLargeCogToSpeedController(stateFrom, stateTo = to.method_11010(), to.method_11016().method_10059((class_2382)from.method_11016())) || RotationPropagator.getRotationSpeedModifier(from, to) != 0.0f || from.isCustomConnection(to, stateFrom, stateTo);
    }

    private static List<KineticBlockEntity> getConnectedNeighbours(KineticBlockEntity be) {
        LinkedList<KineticBlockEntity> neighbours = new LinkedList<KineticBlockEntity>();
        for (class_2338 neighbourPos : RotationPropagator.getPotentialNeighbourLocations(be)) {
            KineticBlockEntity neighbourBE = RotationPropagator.findConnectedNeighbour(be, neighbourPos);
            if (neighbourBE == null) continue;
            neighbours.add(neighbourBE);
        }
        return neighbours;
    }

    private static List<class_2338> getPotentialNeighbourLocations(KineticBlockEntity be) {
        LinkedList<class_2338> neighbours = new LinkedList<class_2338>();
        class_2338 blockPos = be.method_11016();
        class_1937 level = be.method_10997();
        if (!level.method_8477(blockPos)) {
            return neighbours;
        }
        for (class_2350 facing : Iterate.directions) {
            class_2338 relative = blockPos.method_10093(facing);
            if (!level.method_8477(relative)) continue;
            neighbours.add(relative);
        }
        class_2680 blockState = be.method_11010();
        class_2248 class_22482 = blockState.method_26204();
        if (!(class_22482 instanceof IRotate)) {
            return neighbours;
        }
        IRotate block = (IRotate)class_22482;
        return be.addPropagationLocations(block, blockState, neighbours);
    }
}

