/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.packager;

import com.google.common.base.Predicate;
import com.mojang.serialization.Codec;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.AllUnpackingHandlers;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.api.packager.unpacking.UnpackingHandler;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.compat.computercraft.AbstractComputerBehaviour;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceBlockEntity;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.box.PackageStyles;
import com.zurrtum.create.content.logistics.crate.BottomlessItemHandler;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import com.zurrtum.create.content.logistics.packager.IdentifiedInventory;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.packager.PackagerBlock;
import com.zurrtum.create.content.logistics.packager.PackagerItemHandler;
import com.zurrtum.create.content.logistics.packager.PackagingRequest;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.zurrtum.create.content.logistics.packagerLink.PackagerLinkBlock;
import com.zurrtum.create.content.logistics.packagerLink.PackagerLinkBlockEntity;
import com.zurrtum.create.content.logistics.packagerLink.RequestPromiseQueue;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import com.zurrtum.create.infrastructure.packet.s2c.WiFiEffectPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3829;
import net.minecraft.class_8242;
import net.minecraft.class_9288;
import org.jetbrains.annotations.Nullable;

public class PackagerBlockEntity
extends SmartBlockEntity
implements class_3829 {
    private static final Codec<List<BigItemStack>> EXITING_CODEC = BigItemStack.CODEC.listOf();
    public boolean redstonePowered;
    public int buttonCooldown;
    public String signBasedAddress;
    public InvManipulationBehaviour targetInventory;
    public class_1799 heldBox;
    public class_1799 previouslyUnwrapped;
    public List<BigItemStack> queuedExitingPackages;
    public final PackagerItemHandler inventory;
    public static final int CYCLE = 20;
    public int animationTicks;
    public boolean animationInward;
    public Boolean hasCustomComputerAddress;
    public String customComputerAddress;
    private InventorySummary availableItems;
    private VersionedInventoryTrackerBehaviour invVersionTracker;

    public PackagerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.redstonePowered = (Boolean)state.method_61767((class_2769)PackagerBlock.POWERED, (Comparable)Boolean.valueOf(false));
        this.heldBox = class_1799.field_8037;
        this.previouslyUnwrapped = class_1799.field_8037;
        this.inventory = new PackagerItemHandler(this);
        this.animationTicks = 0;
        this.animationInward = true;
        this.queuedExitingPackages = new LinkedList<BigItemStack>();
        this.signBasedAddress = "";
        this.customComputerAddress = "";
        this.hasCustomComputerAddress = false;
        this.buttonCooldown = 0;
    }

    public PackagerBlockEntity(class_2338 pos, class_2680 state) {
        this(AllBlockEntityTypes.PACKAGER, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.targetInventory = (InvManipulationBehaviour)new InvManipulationBehaviour(this, CapManipulationBehaviourBase.InterfaceProvider.oppositeOfBlockFacing()).withFilter((Predicate<class_2586>)((Predicate)this::supportsBlockEntity));
        behaviours.add(this.targetInventory);
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour(this);
        behaviours.add(this.invVersionTracker);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.PACKAGER);
    }

    private boolean supportsBlockEntity(class_2586 target) {
        return target != null && !(target instanceof PortableStorageInterfaceBlockEntity);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.recheckIfLinksPresent();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.buttonCooldown > 0) {
            --this.buttonCooldown;
        }
        if (this.animationTicks == 0) {
            this.previouslyUnwrapped = class_1799.field_8037;
            if (!this.field_11863.method_8608() && !this.queuedExitingPackages.isEmpty() && this.heldBox.method_7960()) {
                BigItemStack entry = this.queuedExitingPackages.getFirst();
                this.heldBox = entry.stack.method_7972();
                --entry.count;
                if (entry.count <= 0) {
                    this.queuedExitingPackages.removeFirst();
                }
                this.animationInward = false;
                this.animationTicks = 20;
                this.notifyUpdate();
            }
            return;
        }
        if (this.field_11863.method_8608()) {
            if (this.animationTicks == 20 - (this.animationInward ? 5 : 1)) {
                AllSoundEvents.PACKAGER.playAt(this.field_11863, (class_2382)this.field_11867, 1.0f, 1.0f, true);
            }
            if (this.animationTicks == (this.animationInward ? 1 : 5)) {
                this.field_11863.method_45446(this.field_11867, class_3417.field_15131, class_3419.field_15245, 0.25f, 0.75f, true);
            }
        }
        --this.animationTicks;
        if (this.animationTicks == 0 && !this.field_11863.method_8608()) {
            this.wakeTheFrogs();
            this.method_5431();
        }
    }

    public void triggerStockCheck() {
        this.getAvailableItems();
    }

    public InventorySummary getAvailableItems() {
        if (this.availableItems != null && this.invVersionTracker.stillWaiting((class_1263)this.targetInventory.getInventory())) {
            return this.availableItems;
        }
        InventorySummary availableItems = new InventorySummary();
        class_1263 targetInv = (class_1263)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            this.availableItems = availableItems;
            return availableItems;
        }
        if (targetInv instanceof BottomlessItemHandler) {
            BottomlessItemHandler bih = (BottomlessItemHandler)targetInv;
            availableItems.add(bih.method_5438(0), 1000000000);
            this.availableItems = availableItems;
            return availableItems;
        }
        int size = targetInv.method_5439();
        for (int slot = 0; slot < size; ++slot) {
            availableItems.add(targetInv.method_5438(slot));
        }
        this.invVersionTracker.awaitNewVersion((class_1263)this.targetInventory.getInventory());
        this.submitNewArrivals(this.availableItems, availableItems);
        this.availableItems = availableItems;
        return availableItems;
    }

    private void submitNewArrivals(InventorySummary before, InventorySummary after) {
        if (before == null || after.isEmpty()) {
            return;
        }
        HashSet<RequestPromiseQueue> promiseQueues = new HashSet<RequestPromiseQueue>();
        for (class_2350 d : Iterate.directions) {
            Object object;
            if (!this.field_11863.method_8477(this.field_11867.method_10093(d))) continue;
            class_2680 adjacentState = this.field_11863.method_8320(this.field_11867.method_10093(d));
            if (adjacentState.method_27852((class_2248)AllBlocks.FACTORY_GAUGE)) {
                if (FactoryPanelBlock.connectedDirection(adjacentState) != d || !((object = this.field_11863.method_8321(this.field_11867.method_10093(d))) instanceof FactoryPanelBlockEntity)) continue;
                FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)object;
                if (!fpbe.restocker) continue;
                object = fpbe.panels.values().iterator();
                while (object.hasNext()) {
                    ServerFactoryPanelBehaviour behaviour = (ServerFactoryPanelBehaviour)object.next();
                    if (!behaviour.isActive()) continue;
                    promiseQueues.add(behaviour.restockerPromises);
                }
            }
            if (!adjacentState.method_27852((class_2248)AllBlocks.STOCK_LINK) || PackagerLinkBlock.getConnectedDirection(adjacentState) != d || !((object = this.field_11863.method_8321(this.field_11867.method_10093(d))) instanceof PackagerLinkBlockEntity)) continue;
            PackagerLinkBlockEntity plbe = (PackagerLinkBlockEntity)object;
            UUID freqId = plbe.behaviour.freqId;
            if (!Create.LOGISTICS.hasQueuedPromises(freqId)) continue;
            promiseQueues.add(Create.LOGISTICS.getQueuedPromises(freqId));
        }
        if (promiseQueues.isEmpty()) {
            return;
        }
        for (BigItemStack entry : after.getStacks()) {
            before.add(entry.stack, -entry.count);
        }
        for (RequestPromiseQueue queue : promiseQueues) {
            for (BigItemStack entry : before.getStacks()) {
                if (entry.count >= 0) continue;
                queue.itemEnteredSystem(entry.stack, -entry.count);
            }
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_11863.method_8608()) {
            return;
        }
        this.recheckIfLinksPresent();
        if (!this.redstonePowered) {
            return;
        }
        this.redstonePowered = (Boolean)this.method_11010().method_61767((class_2769)PackagerBlock.POWERED, (Comparable)Boolean.valueOf(false));
        if (!this.redstoneModeActive()) {
            return;
        }
        this.updateSignAddress();
        this.attemptToSend(null);
    }

    public void recheckIfLinksPresent() {
        boolean isLinked;
        if (this.field_11863.method_8608()) {
            return;
        }
        class_2680 blockState = this.method_11010();
        if (!blockState.method_28498((class_2769)PackagerBlock.LINKED)) {
            return;
        }
        boolean shouldBeLinked = this.getLinkPos() != null;
        if (shouldBeLinked == (isLinked = ((Boolean)blockState.method_11654((class_2769)PackagerBlock.LINKED)).booleanValue())) {
            return;
        }
        this.field_11863.method_8501(this.field_11867, (class_2680)blockState.method_28493((class_2769)PackagerBlock.LINKED));
    }

    public boolean redstoneModeActive() {
        return (Boolean)this.method_11010().method_61767((class_2769)PackagerBlock.LINKED, (Comparable)Boolean.valueOf(false)) == false;
    }

    private class_2338 getLinkPos() {
        for (class_2350 d : Iterate.directions) {
            class_2680 adjacentState = this.field_11863.method_8320(this.field_11867.method_10093(d));
            if (!adjacentState.method_27852((class_2248)AllBlocks.STOCK_LINK) || PackagerLinkBlock.getConnectedDirection(adjacentState) != d) continue;
            return this.field_11867.method_10093(d);
        }
        return null;
    }

    public void flashLink() {
        class_2350[] class_2350Array = this.field_11863;
        if (!(class_2350Array instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_2350Array;
        for (class_2350 d : Iterate.directions) {
            class_2338 adjacentPos = this.field_11867.method_10093(d);
            class_2680 adjacentState = this.field_11863.method_8320(adjacentPos);
            if (!adjacentState.method_27852((class_2248)AllBlocks.STOCK_LINK) || PackagerLinkBlock.getConnectedDirection(adjacentState) != d) continue;
            serverWorld.method_8503().method_3760().method_14605(null, (double)adjacentPos.method_10263(), (double)adjacentPos.method_10264(), (double)adjacentPos.method_10260(), 32.0, serverWorld.method_27983(), (class_2596)new WiFiEffectPacket(adjacentPos));
            return;
        }
    }

    public boolean isTooBusyFor(LogisticallyLinkedBehaviour.RequestType type) {
        int queue = this.queuedExitingPackages.size();
        return queue >= (switch (type) {
            default -> throw new MatchException(null, null);
            case LogisticallyLinkedBehaviour.RequestType.PLAYER -> 50;
            case LogisticallyLinkedBehaviour.RequestType.REDSTONE -> 20;
            case LogisticallyLinkedBehaviour.RequestType.RESTOCK -> 10;
        });
    }

    public void activate() {
        this.redstonePowered = true;
        this.method_5431();
        this.recheckIfLinksPresent();
        if (!this.redstoneModeActive()) {
            return;
        }
        this.updateSignAddress();
        this.attemptToSend(null);
        if (this.buttonCooldown <= 0) {
            this.buttonCooldown = 40;
        }
    }

    public boolean unwrapBox(class_1799 box, boolean simulate) {
        if (this.animationTicks > 0) {
            return false;
        }
        Objects.requireNonNull(this.field_11863);
        ItemStackHandler contents = PackageItem.getContents(box);
        List<class_1799> items = ItemHelper.getNonEmptyStacks(contents);
        if (items.isEmpty()) {
            return true;
        }
        PackageOrderWithCrafts orderContext = PackageItem.getOrderContext(box);
        class_2350 facing = (class_2350)this.method_11010().method_61767((class_2769)PackagerBlock.field_10927, (Comparable)class_2350.field_11036);
        class_2338 target = this.field_11867.method_10093(facing.method_10153());
        class_2680 targetState = this.field_11863.method_8320(target);
        UnpackingHandler handler = UnpackingHandler.REGISTRY.get((class_2688<class_2248, ?>)targetState);
        UnpackingHandler toUse = handler != null ? handler : AllUnpackingHandlers.DEFAULT;
        boolean unpacked = toUse.unpack(this.field_11863, target, targetState, facing, items, orderContext, simulate);
        if (unpacked && !simulate) {
            AbstractComputerBehaviour computer = AbstractComputerBehaviour.get(this);
            if (computer != null) {
                computer.queuePackageReceived(box);
            }
            this.previouslyUnwrapped = box;
            this.animationInward = true;
            this.animationTicks = 20;
            this.notifyUpdate();
        }
        return unpacked;
    }

    public void attemptToSend() {
        class_1799 createdBox;
        if (!this.heldBox.method_7960() || this.animationTicks != 0 || this.buttonCooldown > 0) {
            return;
        }
        class_1263 targetInv = (class_1263)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            return;
        }
        class_1799 stack = targetInv.extractAnyMax();
        if (stack.method_7960()) {
            return;
        }
        if (stack.method_7909().method_31568()) {
            ArrayList<class_1799> list = new ArrayList<class_1799>(9);
            list.add(stack);
            int size = 8;
            for (int i = 0; i < size && !(stack = targetInv.extractMax(s -> s.method_7909().method_31568())).method_7960(); ++i) {
                list.add(stack);
            }
            int size2 = list.size();
            class_9288 contents = new class_9288(size2);
            class_2371 items = contents.field_49338;
            for (int i = 0; i < size2; ++i) {
                items.set(i, (Object)((class_1799)list.get(i)));
            }
            createdBox = PackageStyles.getRandomBox();
            createdBox.method_57379(AllDataComponents.PACKAGE_CONTENTS, (Object)contents);
        } else {
            createdBox = PackagerBlockEntity.createBox(stack);
        }
        this.queuePackage(createdBox, this.signBasedAddress);
    }

    private static class_1799 createBox(class_1799 stack) {
        if (stack.method_7909() instanceof PackageItem) {
            stack = stack.method_7972();
            PackageItem.clearAddress(stack);
            return stack;
        }
        class_9288 contents = new class_9288(1);
        contents.field_49338.set(0, (Object)stack);
        return PackageItem.containing(contents);
    }

    private static class_1799 createBox(class_1799[] list, int size) {
        class_9288 contents = new class_9288(size);
        class_2371 items = contents.field_49338;
        for (int i = 0; i < size; ++i) {
            items.set(i, (Object)list[i]);
        }
        return PackageItem.containing(contents);
    }

    private void queuePackage(class_1799 createdBox, String address) {
        AbstractComputerBehaviour computer;
        if (address != null && !address.isBlank()) {
            PackageItem.addAddress(createdBox, address);
        }
        if ((computer = AbstractComputerBehaviour.get(this)) != null) {
            computer.queuePackageCreated(createdBox);
        }
        if (!this.heldBox.method_7960() || this.animationTicks != 0) {
            this.queuedExitingPackages.add(new BigItemStack(createdBox, 1));
            return;
        }
        this.heldBox = createdBox;
        this.animationInward = false;
        this.animationTicks = 20;
        this.award(AllAdvancements.PACKAGER);
        this.triggerStockCheck();
        this.notifyUpdate();
    }

    /*
     * WARNING - void declaration
     */
    public void attemptToSend(Collection<PackagingRequest> queuedRequests) {
        if (queuedRequests == null) {
            this.attemptToSend();
            return;
        }
        if (queuedRequests.isEmpty()) {
            return;
        }
        class_1263 targetInv = (class_1263)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            return;
        }
        int max = 9;
        class_1799[] list = new class_1799[max];
        int index = 0;
        ArrayList<Object> requests = new ArrayList<Object>(queuedRequests.size());
        ArrayList<Object> bulkyRequests = new ArrayList<Object>();
        ArrayList<class_1799> packages = new ArrayList<class_1799>();
        Iterator<PackagingRequest> iterator = queuedRequests.iterator();
        Object nextRequest = iterator.next();
        while (true) {
            void var19_20;
            class_1799 stack;
            if ((stack = ((PackagingRequest)nextRequest).item()).method_7909().method_31568()) {
                requests.add(nextRequest);
            } else {
                bulkyRequests.add(nextRequest);
            }
            String fixedAddress = ((PackagingRequest)nextRequest).address();
            int fixedOrderId = ((PackagingRequest)nextRequest).orderId();
            PackageOrderWithCrafts orderContext = ((PackagingRequest)nextRequest).context();
            int linkIndexInOrder = ((PackagingRequest)nextRequest).linkIndex();
            boolean finalLinkInOrder = ((PackagingRequest)nextRequest).finalLink().booleanValue();
            int packageIndexAtLink = ((PackagingRequest)nextRequest).packageCounter().intValue();
            nextRequest = null;
            while (iterator.hasNext()) {
                Object current = iterator.next();
                if (((PackagingRequest)current).orderId() == fixedOrderId && ((PackagingRequest)current).address().equals(fixedAddress)) {
                    if (orderContext == null) {
                        orderContext = ((PackagingRequest)current).context();
                    }
                    if ((stack = ((PackagingRequest)current).item()).method_7909().method_31568()) {
                        for (PackagingRequest packagingRequest : requests) {
                            if (!class_1799.method_31577((class_1799)packagingRequest.item(), (class_1799)stack)) continue;
                            packagingRequest.count().add(((PackagingRequest)current).getCount());
                            current = null;
                            break;
                        }
                        if (current == null) continue;
                        requests.add(current);
                        continue;
                    }
                    bulkyRequests.add(current);
                    continue;
                }
                nextRequest = current;
                break;
            }
            for (PackagingRequest packagingRequest : requests) {
                int missing;
                stack = packagingRequest.item();
                int n = targetInv.extract(stack, packagingRequest.getCount());
                if (n == 0) continue;
                int maxSize = stack.method_7914();
                for (int count = n / maxSize; count > 0; count -= missing) {
                    int i;
                    missing = max - index;
                    if (count >= missing) {
                        for (i = 0; i < missing; ++i) {
                            list[index++] = stack.method_46651(maxSize);
                        }
                        packages.add(PackagerBlockEntity.createBox(list, index));
                        index = 0;
                        continue;
                    }
                    for (i = 0; i < count; ++i) {
                        list[index++] = stack.method_46651(maxSize);
                    }
                }
                int remainder = n % maxSize;
                if (remainder == 0) continue;
                list[index++] = stack.method_46651(remainder);
                if (index != max) continue;
                packages.add(PackagerBlockEntity.createBox(list, index));
                index = 0;
            }
            if (index != 0) {
                packages.add(PackagerBlockEntity.createBox(list, index));
            }
            for (PackagingRequest packagingRequest : bulkyRequests) {
                stack = packagingRequest.item();
                int n = targetInv.extract(stack, packagingRequest.getCount());
                if (n == 0) continue;
                packages.add(PackagerBlockEntity.createBox(n == stack.method_7947() ? stack : stack.method_46651(n)));
            }
            int end = packages.size() - 1;
            boolean bl = false;
            while (var19_20 < end) {
                stack = (class_1799)packages.get((int)var19_20);
                PackageItem.setOrder(stack, fixedOrderId, linkIndexInOrder, finalLinkInOrder, packageIndexAtLink++, false, orderContext);
                this.queuePackage(stack, fixedAddress);
                ++var19_20;
            }
            stack = (class_1799)packages.get(end);
            PackageItem.setOrder(stack, fixedOrderId, linkIndexInOrder, finalLinkInOrder, packageIndexAtLink, true, orderContext);
            this.queuePackage(stack, fixedAddress);
            if (nextRequest == null) break;
            index = 0;
            requests.clear();
            bulkyRequests.clear();
            packages.clear();
        }
    }

    public void updateSignAddress() {
        if (this.hasCustomComputerAddress.booleanValue()) {
            AbstractComputerBehaviour computer = AbstractComputerBehaviour.get(this);
            if (computer != null) {
                this.signBasedAddress = this.customComputerAddress;
                return;
            }
            this.hasCustomComputerAddress = false;
        }
        this.signBasedAddress = "";
        for (class_2350 side : Iterate.directions) {
            String address = this.getSign(side);
            if (address == null || address.isBlank()) continue;
            this.signBasedAddress = address;
        }
    }

    protected String getSign(class_2350 side) {
        class_2586 blockEntity = this.field_11863.method_8321(this.field_11867.method_10093(side));
        if (!(blockEntity instanceof class_2625)) {
            return null;
        }
        class_2625 sign = (class_2625)blockEntity;
        for (boolean front : Iterate.trueAndFalse) {
            class_8242 text = sign.method_49843(front);
            Object address = "";
            for (class_2561 component : text.method_49877(false)) {
                String string = component.getString();
                if (string.isBlank()) continue;
                address = (String)address + string.trim() + " ";
            }
            if (((String)address).isBlank()) continue;
            return ((String)address).trim();
        }
        return null;
    }

    protected void wakeTheFrogs() {
        class_2586 class_25862 = this.field_11863.method_8321(this.field_11867.method_10093(class_2350.field_11036));
        if (class_25862 instanceof FrogportBlockEntity) {
            FrogportBlockEntity port = (FrogportBlockEntity)class_25862;
            port.tryPullingFromOwnAndAdjacentInventories();
        }
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.redstonePowered = view.method_71433("Active", false);
        this.animationInward = view.method_71433("AnimationInward", false);
        this.animationTicks = view.method_71424("AnimationTicks", 0);
        this.signBasedAddress = view.method_71428("SignAddress", "");
        this.customComputerAddress = view.method_71428("ComputerAddress", "");
        this.hasCustomComputerAddress = view.method_71433("HasComputerAddress", false);
        this.heldBox = view.method_71426("HeldBox", class_1799.field_24671).orElse(class_1799.field_8037);
        this.previouslyUnwrapped = view.method_71426("InsertedBox", class_1799.field_24671).orElse(class_1799.field_8037);
        if (clientPacket) {
            return;
        }
        this.queuedExitingPackages.clear();
        view.method_71426("QueuedExitingPackages", EXITING_CODEC).ifPresent(list -> this.queuedExitingPackages.addAll((Collection<BigItemStack>)list));
        view.method_71426("LastSummary", InventorySummary.CODEC).ifPresent(summary -> {
            this.availableItems = summary;
        });
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71472("Active", this.redstonePowered);
        view.method_71472("AnimationInward", this.animationInward);
        view.method_71465("AnimationTicks", this.animationTicks);
        view.method_71469("SignAddress", this.signBasedAddress);
        view.method_71469("ComputerAddress", this.customComputerAddress);
        view.method_71472("HasComputerAddress", this.hasCustomComputerAddress.booleanValue());
        if (!this.heldBox.method_7960()) {
            view.method_71468("HeldBox", class_1799.field_24671, (Object)this.heldBox);
        }
        if (!this.previouslyUnwrapped.method_7960()) {
            view.method_71468("InsertedBox", class_1799.field_24671, (Object)this.previouslyUnwrapped);
        }
        if (clientPacket) {
            return;
        }
        view.method_71468("QueuedExitingPackages", EXITING_CODEC, this.queuedExitingPackages);
        if (this.availableItems != null) {
            view.method_71468("LastSummary", InventorySummary.CODEC, (Object)this.availableItems);
        }
    }

    public void method_5448() {
        this.inventory.method_5447(0, class_1799.field_8037);
        this.queuedExitingPackages.clear();
    }

    @Override
    public void destroy() {
        super.destroy();
        class_1264.method_5451((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1263)this.inventory);
        this.queuedExitingPackages.forEach(bigStack -> {
            for (int i = 0; i < bigStack.count; ++i) {
                class_1264.method_5449((class_1937)this.field_11863, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (class_1799)bigStack.stack.method_7972());
            }
        });
        this.queuedExitingPackages.clear();
    }

    public float getTrayOffset(float partialTicks) {
        float tickCycle = this.animationInward ? (float)this.animationTicks - partialTicks : (float)(this.animationTicks - 5) - partialTicks;
        float progress = class_3532.method_15363((float)(tickCycle / 15.0f * 2.0f - 1.0f), (float)-1.0f, (float)1.0f);
        progress = 1.0f - progress * progress;
        return progress * progress;
    }

    public class_1799 getRenderedBox() {
        if (this.animationInward) {
            return this.animationTicks <= 10 ? class_1799.field_8037 : this.previouslyUnwrapped;
        }
        return this.animationTicks >= 10 ? class_1799.field_8037 : this.heldBox;
    }

    public boolean isTargetingSameInventory(@Nullable IdentifiedInventory inventory) {
        if (inventory == null) {
            return false;
        }
        class_1263 targetHandler = (class_1263)this.targetInventory.getInventory();
        if (targetHandler == null) {
            return false;
        }
        if (inventory.identifier() != null) {
            BlockFace face = this.targetInventory.getTarget().getOpposite();
            return inventory.identifier().contains(face);
        }
        return PackagerBlockEntity.isSameInventoryFallback(targetHandler, inventory.handler());
    }

    private static boolean isSameInventoryFallback(class_1263 first, class_1263 second) {
        if (first == second) {
            return true;
        }
        int secondSize = second.method_5439();
        for (int i = 0; i < secondSize; ++i) {
            class_1799 stackInSlot = second.method_5438(i);
            if (stackInSlot.method_7960()) continue;
            int firstSize = first.method_5439();
            for (int j = 0; j < firstSize; ++j) {
                if (stackInSlot != first.method_5438(j)) continue;
                return true;
            }
            break;
        }
        return false;
    }
}

