/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.track;

import com.zurrtum.create.Create;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.EdgeData;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.graph.TrackGraphHelper;
import com.zurrtum.create.content.trains.graph.TrackGraphLocation;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.content.trains.signal.SingleBlockEntityEdgePoint;
import com.zurrtum.create.content.trains.signal.TrackEdgePoint;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.jetbrains.annotations.Nullable;

public class TrackTargetingBehaviour<T extends TrackEdgePoint>
extends BlockEntityBehaviour<SmartBlockEntity> {
    public static final BehaviourType<TrackTargetingBehaviour<?>> TYPE = new BehaviourType();
    private class_2338 targetTrack;
    private BezierTrackPointLocation targetBezier;
    private class_2350.class_2352 targetDirection;
    private UUID id;
    private class_243 prevDirection;
    private class_243 rotatedDirection;
    private class_2487 migrationData;
    private EdgePointType<T> edgePointType;
    private T edgePoint;
    private boolean orthogonal;

    public TrackTargetingBehaviour(SmartBlockEntity be, EdgePointType<T> edgePointType) {
        super(be);
        this.edgePointType = edgePointType;
        this.targetDirection = class_2350.class_2352.field_11056;
        this.targetTrack = class_2338.field_10980;
        this.id = UUID.randomUUID();
        this.migrationData = null;
        this.orthogonal = false;
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71468("Id", class_4844.field_25122, (Object)this.id);
        view.method_71468("TargetTrack", class_2338.field_25064, (Object)this.targetTrack);
        view.method_71472("Ortho", this.orthogonal);
        view.method_71472("TargetDirection", this.targetDirection == class_2350.class_2352.field_11056);
        if (this.rotatedDirection != null) {
            view.method_71468("RotatedAxis", class_243.field_38277, (Object)this.rotatedDirection);
        }
        if (this.prevDirection != null) {
            view.method_71468("PrevAxis", class_243.field_38277, (Object)this.prevDirection);
        }
        if (this.migrationData != null && !clientPacket) {
            view.method_71468("Migrate", class_2487.field_25128, (Object)this.migrationData);
        }
        if (this.targetBezier != null) {
            class_11372 bezier = view.method_71461("Bezier");
            bezier.method_71465("Segment", this.targetBezier.segment());
            bezier.method_71468("Key", class_2338.field_25064, (Object)this.targetBezier.curveTarget().method_10059((class_2382)this.getPos()));
        }
        super.write(view, clientPacket);
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        this.id = view.method_71426("Id", class_4844.field_25122).orElseGet(UUID::randomUUID);
        this.targetTrack = view.method_71426("TargetTrack", class_2338.field_25064).orElse(class_2338.field_10980);
        this.targetDirection = view.method_71433("TargetDirection", false) ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060;
        this.orthogonal = view.method_71433("Ortho", false);
        view.method_71426("RotatedAxis", class_243.field_38277).ifPresent(rotated -> {
            this.rotatedDirection = rotated;
        });
        view.method_71426("PrevAxis", class_243.field_38277).ifPresent(prev -> {
            this.prevDirection = prev;
        });
        view.method_71426("Migrate", class_2487.field_25128).ifPresent(migration -> {
            this.migrationData = migration;
        });
        if (clientPacket) {
            this.edgePoint = null;
        }
        view.method_71420("Bezier").ifPresent(bezier -> {
            class_2338 key = bezier.method_71426("Key", class_2338.field_25064).orElse(class_2338.field_10980);
            this.targetBezier = new BezierTrackPointLocation(key.method_10081((class_2382)this.getPos()), bezier.method_71424("Segment", 0));
        });
        super.read(view, clientPacket);
    }

    @Nullable
    public T getEdgePoint() {
        return this.edgePoint;
    }

    public void invalidateEdgePoint(class_2487 migrationData) {
        this.migrationData = migrationData;
        this.edgePoint = null;
        this.blockEntity.sendData();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.edgePoint == null) {
            this.edgePoint = this.createEdgePoint();
        }
    }

    public T createEdgePoint() {
        class_1937 level = this.getWorld();
        boolean isClientSide = level.method_8608();
        if (this.migrationData == null || isClientSide) {
            for (TrackGraph trackGraph : Create.RAILWAYS.sided((class_1936)level).trackNetworks.values()) {
                T point = trackGraph.getPoint(this.edgePointType, this.id);
                if (point == null) continue;
                return point;
            }
        }
        if (isClientSide) {
            return null;
        }
        if (!this.hasValidTrack()) {
            return null;
        }
        TrackGraphLocation loc = this.determineGraphLocation();
        if (loc == null) {
            return null;
        }
        TrackGraph graph = loc.graph;
        TrackNode node1 = graph.locateNode((TrackNodeLocation)((Object)loc.edge.getFirst()));
        TrackNode node2 = graph.locateNode((TrackNodeLocation)((Object)loc.edge.getSecond()));
        TrackEdge edge = graph.getConnectionsFrom(node1).get(node2);
        if (edge == null) {
            return null;
        }
        T point = this.edgePointType.create();
        boolean front = this.getTargetDirection() == class_2350.class_2352.field_11056;
        this.prevDirection = edge.getDirectionAt(loc.position).method_1021(front ? -1.0 : 1.0);
        if (this.rotatedDirection != null) {
            double dot = this.prevDirection.method_1026(this.rotatedDirection);
            if (dot < (double)-0.85f) {
                this.rotatedDirection = null;
                this.targetDirection = this.targetDirection.method_26424();
                return null;
            }
            this.rotatedDirection = null;
        }
        double length = edge.getLength();
        class_2487 data = this.migrationData;
        this.migrationData = null;
        this.orthogonal = this.targetBezier == null;
        class_243 direction = edge.getDirection(true);
        int nonZeroComponents = 0;
        for (class_2350.class_2351 axis : Iterate.axes) {
            nonZeroComponents += direction.method_18043(axis) != 0.0 ? 1 : 0;
        }
        this.orthogonal &= nonZeroComponents <= 1;
        EdgeData signalData = edge.getEdgeData();
        if (signalData.hasPoints()) {
            for (EdgePointType<?> otherType : EdgePointType.TYPES.values()) {
                Object otherPoint = signalData.get(otherType, loc.position);
                if (otherPoint == null) continue;
                if (otherType != this.edgePointType) {
                    if (((TrackEdgePoint)otherPoint).canCoexistWith(this.edgePointType, front)) continue;
                    return null;
                }
                if (!((TrackEdgePoint)otherPoint).canMerge()) {
                    return null;
                }
                ((TrackEdgePoint)otherPoint).blockEntityAdded(this.blockEntity, front);
                this.id = ((TrackEdgePoint)otherPoint).getId();
                this.blockEntity.notifyUpdate();
                return (T)otherPoint;
            }
        }
        if (data != null) {
            try (class_8942.class_11340 logging = new class_8942.class_11340(this.blockEntity.method_71402(), Create.LOGGER);){
                class_11368 view = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)level.method_30349(), (class_2487)data);
                DimensionPalette dimensions = (DimensionPalette)view.method_71426("DimensionPalette", DimensionPalette.CODEC).orElseThrow();
                ((TrackEdgePoint)point).read(view, true, dimensions);
            }
        }
        ((TrackEdgePoint)point).setId(this.id);
        boolean reverseEdge = front || point instanceof SingleBlockEntityEdgePoint;
        ((TrackEdgePoint)point).setLocation((Couple<TrackNodeLocation>)(reverseEdge ? loc.edge : loc.edge.swap()), reverseEdge ? loc.position : length - loc.position);
        ((TrackEdgePoint)point).blockEntityAdded(this.blockEntity, front);
        loc.graph.addPoint(level.method_8503(), this.edgePointType, point);
        this.blockEntity.sendData();
        return point;
    }

    @Override
    public void destroy() {
        class_1937 world;
        super.destroy();
        if (this.edgePoint != null && !(world = this.getWorld()).method_8608()) {
            ((TrackEdgePoint)this.edgePoint).blockEntityRemoved(world.method_8503(), this.getPos(), this.getTargetDirection() == class_2350.class_2352.field_11056);
        }
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public boolean isOnCurve() {
        return this.targetBezier != null;
    }

    public boolean isOrthogonal() {
        return this.orthogonal;
    }

    public boolean hasValidTrack() {
        return this.getTrackBlockState().method_26204() instanceof ITrackBlock;
    }

    public ITrackBlock getTrack() {
        return (ITrackBlock)this.getTrackBlockState().method_26204();
    }

    public class_2680 getTrackBlockState() {
        return this.getWorld().method_8320(this.getGlobalPosition());
    }

    public class_2338 getGlobalPosition() {
        return this.targetTrack.method_10081((class_2382)this.blockEntity.method_11016());
    }

    public class_2338 getPositionForMapMarker() {
        class_2586 class_25862;
        class_2338 target = this.targetTrack.method_10081((class_2382)this.blockEntity.method_11016());
        if (this.targetBezier != null && (class_25862 = this.getWorld().method_8321(target)) instanceof TrackBlockEntity) {
            TrackBlockEntity tbe = (TrackBlockEntity)class_25862;
            BezierConnection bc = tbe.getConnections().get(this.targetBezier.curveTarget());
            if (bc == null) {
                return target;
            }
            double length = class_3532.method_15357((double)(bc.getLength() * 2.0));
            int seg = this.targetBezier.segment() + 1;
            double t = (double)seg / length;
            return class_2338.method_49638((class_2374)bc.getPosition(t));
        }
        return target;
    }

    public class_2350.class_2352 getTargetDirection() {
        return this.targetDirection;
    }

    public BezierTrackPointLocation getTargetBezier() {
        return this.targetBezier;
    }

    public TrackGraphLocation determineGraphLocation() {
        class_1937 level = this.getWorld();
        class_2338 pos = this.getGlobalPosition();
        class_2680 state = this.getTrackBlockState();
        ITrackBlock track = this.getTrack();
        List<class_243> trackAxes = track.getTrackAxes((class_1922)level, pos, state);
        class_2350.class_2352 targetDirection = this.getTargetDirection();
        return this.targetBezier != null ? TrackGraphHelper.getBezierGraphLocationAt(level, pos, targetDirection, this.targetBezier) : TrackGraphHelper.getGraphLocationAt(level, pos, targetDirection, trackAxes.getFirst());
    }

    public void transform(class_2586 be, StructureTransform transform) {
        this.id = UUID.randomUUID();
        this.targetTrack = transform.applyWithoutOffset(this.targetTrack);
        if (this.prevDirection != null) {
            this.rotatedDirection = transform.applyWithoutOffsetUncentered(this.prevDirection);
        }
        if (this.targetBezier != null) {
            this.targetBezier = new BezierTrackPointLocation(transform.applyWithoutOffset(this.targetBezier.curveTarget().method_10059((class_2382)this.getPos())).method_10081((class_2382)this.getPos()), this.targetBezier.segment());
        }
        this.blockEntity.notifyUpdate();
    }

    public static enum RenderedTrackOverlayType {
        STATION,
        SIGNAL,
        DUAL_SIGNAL,
        OBSERVER;

    }
}

