/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.blockEntity.behaviour.inventory;

import com.google.common.base.Predicates;
import com.zurrtum.create.api.packager.InventoryIdentifier;
import com.zurrtum.create.content.logistics.packager.IdentifiedInventory;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.zurrtum.create.foundation.item.ItemHelper;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;

public class InvManipulationBehaviour
extends CapManipulationBehaviourBase<class_1263, InvManipulationBehaviour> {
    public static final BehaviourType<InvManipulationBehaviour> TYPE = new BehaviourType();
    public static final BehaviourType<InvManipulationBehaviour> EXTRACT = new BehaviourType();
    public static final BehaviourType<InvManipulationBehaviour> INSERT = new BehaviourType();
    private final BehaviourType<InvManipulationBehaviour> behaviourType;

    public static InvManipulationBehaviour forExtraction(SmartBlockEntity be, CapManipulationBehaviourBase.InterfaceProvider target) {
        return new InvManipulationBehaviour(EXTRACT, be, target);
    }

    public static InvManipulationBehaviour forInsertion(SmartBlockEntity be, CapManipulationBehaviourBase.InterfaceProvider target) {
        return new InvManipulationBehaviour(INSERT, be, target);
    }

    public InvManipulationBehaviour(SmartBlockEntity be, CapManipulationBehaviourBase.InterfaceProvider target) {
        this(TYPE, be, target);
    }

    private InvManipulationBehaviour(BehaviourType<InvManipulationBehaviour> type, SmartBlockEntity be, CapManipulationBehaviourBase.InterfaceProvider target) {
        super(be, target);
        this.behaviourType = type;
    }

    @Nullable
    public IdentifiedInventory getIdentifiedInventory() {
        class_1263 inventory = (class_1263)this.getInventory();
        if (inventory == null) {
            return null;
        }
        InventoryIdentifier identifier = InventoryIdentifier.get(this.getWorld(), this.getTarget().getOpposite());
        return new IdentifiedInventory(identifier, inventory);
    }

    @Override
    protected class_1263 getCapability(class_1937 world, class_2338 pos, class_2586 blockEntity, @Nullable class_2350 side) {
        return ItemHelper.getInventory(world, pos, null, blockEntity, side);
    }

    public class_1799 extract() {
        return this.extract(this.getModeFromFilter(), this.getAmountFromFilter());
    }

    public class_1799 extract(ItemHelper.ExtractionCountMode mode, int amount) {
        return this.extract(mode, amount, (Predicate<class_1799>)Predicates.alwaysTrue());
    }

    public class_1799 extract(ItemHelper.ExtractionCountMode mode, int amount, Predicate<class_1799> filter) {
        boolean shouldSimulate = this.simulateNext;
        this.simulateNext = false;
        if (this.getWorld().method_8608()) {
            return class_1799.field_8037;
        }
        class_1263 inventory = (class_1263)this.targetCapability;
        if (inventory == null) {
            return class_1799.field_8037;
        }
        Predicate<class_1799> test = this.getFilterTest(filter);
        class_1799 extract = mode == ItemHelper.ExtractionCountMode.UPTO ? inventory.count(test, amount) : inventory.preciseCount(test, amount);
        int count = extract.method_7947();
        if (count == 0) {
            return extract;
        }
        int maxCount = extract.method_7914();
        if (count > maxCount) {
            extract.method_7939(count);
        }
        if (shouldSimulate) {
            return extract;
        }
        if (mode == ItemHelper.ExtractionCountMode.UPTO) {
            count = inventory.extract(extract);
            extract.method_7939(count);
            return extract;
        }
        if (inventory.preciseExtract(extract)) {
            return extract;
        }
        return class_1799.field_8037;
    }

    public class_1799 insert(class_1799 stack) {
        int count;
        boolean shouldSimulate = this.simulateNext;
        this.simulateNext = false;
        class_1263 inventory = (class_1263)this.targetCapability;
        if (inventory == null) {
            return stack;
        }
        int insert = shouldSimulate ? inventory.countSpace(stack) : inventory.insertExist(stack);
        if (insert == (count = stack.method_7947())) {
            return class_1799.field_8037;
        }
        if (insert == 0) {
            return stack;
        }
        return stack.method_46651(count - insert);
    }

    protected Predicate<class_1799> getFilterTest(Predicate<class_1799> customFilter) {
        Predicate<class_1799> test = customFilter;
        ServerFilteringBehaviour filter = this.blockEntity.getBehaviour(ServerFilteringBehaviour.TYPE);
        if (filter != null) {
            test = customFilter.and(filter::test);
        }
        return test;
    }

    @Override
    public BehaviourType<?> getType() {
        return this.behaviourType;
    }
}

