/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.collision;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.foundation.collision.CollisionList;
import com.zurrtum.create.foundation.collision.Matrix3d;
import com.zurrtum.create.foundation.collision.OrientedBB;
import net.minecraft.class_243;

public class ContinuousOBBCollider {
    static final class_243 uA0 = new class_243(1.0, 0.0, 0.0);
    static final class_243 uA1 = new class_243(0.0, 1.0, 0.0);
    static final class_243 uA2 = new class_243(0.0, 0.0, 1.0);
    static int checkCount = 0;

    public static CollisionResponse collideMany(CollisionList collidableBBs, CollisionList denseViableColliders, OrientedBB obb, class_243 motion, float entityMaxStep, boolean doHorizontalPass) {
        class_243 obbCenter = obb.center;
        class_243 obbExtents = obb.extents;
        Matrix3d rotation = obb.rotation;
        double a00 = Math.abs(rotation.m00);
        double a01 = Math.abs(rotation.m01);
        double a02 = Math.abs(rotation.m02);
        double a10 = Math.abs(rotation.m10);
        double a11 = Math.abs(rotation.m11);
        double a12 = Math.abs(rotation.m12);
        double a20 = Math.abs(rotation.m20);
        double a21 = Math.abs(rotation.m21);
        double a22 = Math.abs(rotation.m22);
        double aabbInLocalX = (a00 + a01 + a02) * obbExtents.field_1352 + 0.5;
        double aabbInLocalY = (a10 + a11 + a12) * obbExtents.field_1351 + 0.5;
        double aabbInLocalZ = (a20 + a21 + a22) * obbExtents.field_1350 + 0.5;
        CollisionList.Populate populateDenseViableColliders = new CollisionList.Populate(denseViableColliders);
        denseViableColliders.size = 0;
        for (int bbIdx = 0; bbIdx < collidableBBs.size; ++bbIdx) {
            if (Math.abs(obbCenter.field_1352 + motion.field_1352 - collidableBBs.centerX[bbIdx]) > collidableBBs.extentsX[bbIdx] + aabbInLocalX || Math.abs(obbCenter.field_1351 + motion.field_1351 - collidableBBs.centerY[bbIdx]) > collidableBBs.extentsY[bbIdx] + aabbInLocalY || Math.abs(obbCenter.field_1350 + motion.field_1350 - collidableBBs.centerZ[bbIdx]) > collidableBBs.extentsZ[bbIdx] + aabbInLocalZ) continue;
            populateDenseViableColliders.appendFrom(collidableBBs, bbIdx);
        }
        if (denseViableColliders.size == 0) {
            CollisionResponse out = new CollisionResponse();
            out.surfaceCollision = false;
            out.collisionResponse = class_243.field_1353;
            out.normal = class_243.field_1353;
            out.location = class_243.field_1353;
            out.temporalResponse = 1.0;
            return out;
        }
        double collisionResponseX = 0.0;
        double collisionResponseY = 0.0;
        double collisionResponseZ = 0.0;
        double locationX = 0.0;
        double locationY = 0.0;
        double locationZ = 0.0;
        double normalX = 0.0;
        double normalY = 0.0;
        double normalZ = 0.0;
        boolean surfaceCollision = false;
        double temporalResponse = 1.0;
        class_243 uB0 = new class_243(rotation.m00, rotation.m10, rotation.m20).method_1029();
        class_243 uB1 = new class_243(rotation.m01, rotation.m11, rotation.m21).method_1029();
        class_243 uB2 = new class_243(rotation.m02, rotation.m12, rotation.m22).method_1029();
        class_243 motion2 = rotation.transformTransposed(motion);
        ContinuousSeparationManifold mf = new ContinuousSeparationManifold(uB1);
        for (boolean horizontalPass : Iterate.trueAndFalse) {
            boolean noVerticalCollision;
            boolean verticalPass;
            boolean bl = verticalPass = !horizontalPass || !doHorizontalPass;
            if (horizontalPass && !doHorizontalPass) continue;
            for (int bbIdx = 0; bbIdx < denseViableColliders.size; ++bbIdx) {
                double timeOfImpact;
                boolean isTemporal;
                double deltaX = obbCenter.field_1352 + collisionResponseX - denseViableColliders.centerX[bbIdx];
                double deltaY = obbCenter.field_1351 + collisionResponseY - denseViableColliders.centerY[bbIdx];
                double deltaZ = obbCenter.field_1350 + collisionResponseZ - denseViableColliders.centerZ[bbIdx];
                checkCount = 0;
                mf.reset();
                double extentsX = denseViableColliders.extentsX[bbIdx];
                double extentsY = denseViableColliders.extentsY[bbIdx];
                double extentsZ = denseViableColliders.extentsZ[bbIdx];
                if (mf.separate(uA0, deltaX, extentsX, a00 * obbExtents.field_1352 + a01 * obbExtents.field_1351 + a02 * obbExtents.field_1350, motion.field_1352, true) || mf.separate(uA1, deltaY, extentsY, a10 * obbExtents.field_1352 + a11 * obbExtents.field_1351 + a12 * obbExtents.field_1350, motion.field_1351, true) || mf.separate(uA2, deltaZ, extentsZ, a20 * obbExtents.field_1352 + a21 * obbExtents.field_1351 + a22 * obbExtents.field_1350, motion.field_1350, true)) continue;
                class_243 deltaEntityFrame = rotation.transformTransposed(deltaX, deltaY, deltaZ);
                if (mf.separate(uB0, deltaEntityFrame.field_1352, extentsX * a00 + extentsY * a10 + extentsZ * a20, obbExtents.field_1352, motion2.field_1352, false) || mf.separate(uB1, deltaEntityFrame.field_1351, extentsX * a01 + extentsY * a11 + extentsZ * a21, obbExtents.field_1351, motion2.field_1351, false) || mf.separate(uB2, deltaEntityFrame.field_1350, extentsX * a02 + extentsY * a12 + extentsZ * a22, obbExtents.field_1350, motion2.field_1350, false)) continue;
                if (verticalPass && !surfaceCollision) {
                    surfaceCollision = true;
                }
                boolean bl2 = isTemporal = (timeOfImpact = mf.getTimeOfImpact()) > 0.0 && timeOfImpact < 1.0;
                if (!isTemporal && mf.isDiscreteCollision) {
                    if (mf.stepSeparation <= (double)entityMaxStep) {
                        sep = ContinuousSeparationManifold.withSignedEpsilon(mf.stepSeparation);
                        collisionResponseX += mf.stepSeparationAxis.field_1352 * sep;
                        collisionResponseY += mf.stepSeparationAxis.field_1351 * sep;
                        collisionResponseZ += mf.stepSeparationAxis.field_1350 * sep;
                    } else {
                        sep = ContinuousSeparationManifold.withSignedEpsilon(mf.separation);
                        collisionResponseX += mf.axis.field_1352 * sep;
                        collisionResponseY += mf.axis.field_1351 * sep;
                        collisionResponseZ += mf.axis.field_1350 * sep;
                    }
                    timeOfImpact = 0.0;
                }
                if (timeOfImpact >= 0.0 && temporalResponse > timeOfImpact) {
                    double scale = ContinuousSeparationManifold.withSignedEpsilon(mf.normalSeparation);
                    normalX = mf.normalAxis.field_1352 * scale;
                    normalY = mf.normalAxis.field_1351 * scale;
                    normalZ = mf.normalAxis.field_1350 * scale;
                    locationX = mf.collisionX;
                    locationY = mf.collisionY;
                    locationZ = mf.collisionZ;
                }
                if (!isTemporal || !(temporalResponse > timeOfImpact)) continue;
                temporalResponse = timeOfImpact;
            }
            if (verticalPass) break;
            boolean noVerticalMotionResponse = temporalResponse == 1.0;
            boolean bl3 = noVerticalCollision = collisionResponseY == 0.0;
            if (noVerticalCollision && noVerticalMotionResponse) break;
            collisionResponseX *= 1.0078125;
            collisionResponseZ *= 1.0078125;
        }
        CollisionResponse out = new CollisionResponse();
        out.surfaceCollision = surfaceCollision;
        out.collisionResponse = new class_243(collisionResponseX, collisionResponseY, collisionResponseZ);
        out.normal = new class_243(normalX, normalY, normalZ);
        out.location = new class_243(locationX, locationY, locationZ);
        out.temporalResponse = temporalResponse;
        return out;
    }

    public static class CollisionResponse {
        public boolean surfaceCollision;
        public class_243 collisionResponse;
        public class_243 normal;
        public class_243 location;
        public double temporalResponse;
    }

    private static class ContinuousSeparationManifold {
        static final double UNDEFINED = -1.0;
        double latestCollisionEntryTime = -1.0;
        double earliestCollisionExitTime = Double.MAX_VALUE;
        boolean isDiscreteCollision = true;
        double collisionX;
        double collisionY;
        double collisionZ;
        final class_243 stepSeparationAxis;
        double stepSeparation;
        class_243 normalAxis;
        double normalSeparation;
        class_243 axis;
        double separation;

        public ContinuousSeparationManifold(class_243 stepSeparationAxis) {
            this.stepSeparationAxis = stepSeparationAxis;
        }

        boolean separate(class_243 axis, double TL, double rA, double rB, double projectedMotion, boolean axisOfObjA) {
            double dot;
            boolean discreteCollision;
            ++checkCount;
            double distance = Math.abs(TL);
            double diff = distance - (rA + rB);
            boolean bl = discreteCollision = diff <= 0.0;
            if (!discreteCollision && Math.signum(projectedMotion) == Math.signum(TL)) {
                return true;
            }
            double sTL = Math.signum(TL);
            double separation = sTL * Math.abs(diff);
            if (!discreteCollision) {
                this.isDiscreteCollision = false;
                if (Math.abs(separation) > Math.abs(projectedMotion)) {
                    return true;
                }
                double entryTime = Math.abs(separation) / Math.abs(projectedMotion);
                double exitTime = (diff + Math.abs(rA) + Math.abs(rB)) / Math.abs(projectedMotion);
                this.latestCollisionEntryTime = Math.max(entryTime, this.latestCollisionEntryTime);
                this.earliestCollisionExitTime = Math.min(exitTime, this.earliestCollisionExitTime);
            }
            if (axisOfObjA && distance != 0.0 && -diff <= Math.abs(this.normalSeparation)) {
                this.normalAxis = axis;
                this.normalSeparation = separation;
            }
            if ((dot = this.stepSeparationAxis.method_1026(axis)) != 0.0 && discreteCollision) {
                class_243 cross = axis.method_1036(this.stepSeparationAxis);
                double dotSeparation = Math.signum(dot) * TL - (rA + rB);
                double stepSeparation = -dotSeparation;
                if (!cross.equals((Object)class_243.field_1353)) {
                    class_243 sepVec = axis.method_1021(dotSeparation);
                    class_243 axisPlane = axis.method_1036(cross);
                    class_243 stepPlane = this.stepSeparationAxis.method_1036(cross);
                    class_243 stepSeparationVec = sepVec.method_1020(axisPlane.method_1021(sepVec.method_1026(stepPlane) / axisPlane.method_1026(stepPlane)));
                    stepSeparation = stepSeparationVec.method_1033();
                    if (Math.abs(this.stepSeparation) > Math.abs(stepSeparation) && stepSeparation != 0.0) {
                        this.stepSeparation = stepSeparation;
                    }
                } else if (Math.abs(this.stepSeparation) > stepSeparation) {
                    this.stepSeparation = stepSeparation;
                }
            }
            if (distance != 0.0 && -diff <= Math.abs(this.separation)) {
                this.axis = axis;
                this.separation = separation;
                double scale = Math.signum(TL) * (axisOfObjA ? -rA : -rB) - Math.signum(separation) * 0.125;
                this.collisionX = axis.field_1352 * scale;
                this.collisionY = axis.field_1351 * scale;
                this.collisionZ = axis.field_1350 * scale;
            }
            return false;
        }

        public double getTimeOfImpact() {
            if (this.latestCollisionEntryTime == -1.0) {
                return -1.0;
            }
            if (this.latestCollisionEntryTime > this.earliestCollisionExitTime) {
                return -1.0;
            }
            return this.latestCollisionEntryTime;
        }

        private static double withSignedEpsilon(double sep) {
            return sep + Math.signum(sep) * 1.0E-4;
        }

        public void reset() {
            this.axis = null;
            this.normalAxis = null;
            this.separation = Double.MAX_VALUE;
            this.stepSeparation = Double.MAX_VALUE;
            this.normalSeparation = Double.MAX_VALUE;
            this.latestCollisionEntryTime = -1.0;
            this.earliestCollisionExitTime = Double.MAX_VALUE;
            this.isDiscreteCollision = true;
        }
    }
}

