/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.packet.s2c;

import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllPackets;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.EdgeData;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.content.trains.signal.TrackEdgePoint;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackMaterial;
import com.zurrtum.create.infrastructure.packet.s2c.TrackGraphPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2602;
import net.minecraft.class_9139;
import net.minecraft.class_9145;

public class TrackGraphSyncPacket
extends TrackGraphPacket {
    public static final class_9139<class_2540, TrackGraphSyncPacket> CODEC = class_9139.method_56438(TrackGraphSyncPacket::write, TrackGraphSyncPacket::new);
    public static final int NULL_GROUP = 0;
    public static final int PASSIVE_GROUP = 1;
    public static final int GROUP = 2;
    public Map<Integer, Pair<TrackNodeLocation, class_243>> addedNodes;
    public List<Pair<Pair<Couple<Integer>, TrackMaterial>, BezierConnection>> addedEdges;
    public List<Integer> removedNodes;
    public List<TrackEdgePoint> addedEdgePoints;
    public List<UUID> removedEdgePoints;
    public Map<Integer, Pair<Integer, UUID>> splitSubGraphs;
    public Map<Couple<Integer>, Pair<Integer, List<UUID>>> updatedEdgeData;
    public boolean fullWipe;

    public void apply(class_2602 listener) {
        AllClientHandle.INSTANCE.onTrackGraphSync(this);
    }

    public class_9145<TrackGraphSyncPacket> method_65080() {
        return AllPackets.SYNC_RAIL_GRAPH;
    }

    public TrackGraphSyncPacket(UUID graphId, int netId) {
        this.graphId = graphId;
        this.netId = netId;
        this.addedNodes = new HashMap<Integer, Pair<TrackNodeLocation, class_243>>();
        this.addedEdges = new ArrayList<Pair<Pair<Couple<Integer>, TrackMaterial>, BezierConnection>>();
        this.removedNodes = new ArrayList<Integer>();
        this.addedEdgePoints = new ArrayList<TrackEdgePoint>();
        this.removedEdgePoints = new ArrayList<UUID>();
        this.updatedEdgeData = new HashMap<Couple<Integer>, Pair<Integer, List<UUID>>>();
        this.splitSubGraphs = new HashMap<Integer, Pair<Integer, UUID>>();
        this.packetDeletesGraph = false;
    }

    public TrackGraphSyncPacket(class_2540 buffer) {
        int i;
        this.graphId = buffer.method_10790();
        this.netId = buffer.readInt();
        this.packetDeletesGraph = buffer.readBoolean();
        this.fullWipe = buffer.readBoolean();
        if (this.packetDeletesGraph) {
            return;
        }
        DimensionPalette dimensions = (DimensionPalette)DimensionPalette.PACKET_CODEC.decode((Object)buffer);
        this.addedNodes = new HashMap<Integer, Pair<TrackNodeLocation, class_243>>();
        this.addedEdges = new ArrayList<Pair<Pair<Couple<Integer>, TrackMaterial>, BezierConnection>>();
        this.addedEdgePoints = new ArrayList<TrackEdgePoint>();
        this.removedEdgePoints = new ArrayList<UUID>();
        this.removedNodes = new ArrayList<Integer>();
        this.splitSubGraphs = new HashMap<Integer, Pair<Integer, UUID>>();
        this.updatedEdgeData = new HashMap<Couple<Integer>, Pair<Integer, List<UUID>>>();
        int size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            this.removedNodes.add(buffer.method_10816());
        }
        size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            this.addedNodes.put(buffer.method_10816(), Pair.of(TrackNodeLocation.receive(buffer, dimensions), VecHelper.read(buffer)));
        }
        size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            this.addedEdges.add(Pair.of(Pair.of(Couple.create(() -> ((class_2540)buffer).method_10816()), (TrackMaterial)TrackMaterial.PACKET_CODEC.decode((Object)buffer)), buffer.readBoolean() ? new BezierConnection(buffer) : null));
        }
        size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            this.addedEdgePoints.add(EdgePointType.read(buffer, dimensions));
        }
        size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            this.removedEdgePoints.add(buffer.method_10790());
        }
        size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            ArrayList<UUID> list = new ArrayList<UUID>();
            Couple<Integer> key = Couple.create(() -> ((class_2540)buffer).readInt());
            Pair entry = Pair.of(buffer.method_10816(), list);
            int size2 = buffer.method_10816();
            for (int j = 0; j < size2; ++j) {
                list.add(buffer.method_10790());
            }
            this.updatedEdgeData.put(key, entry);
        }
        size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            this.splitSubGraphs.put(buffer.method_10816(), Pair.of(buffer.readInt(), buffer.method_10790()));
        }
    }

    public void write(class_2540 buffer) {
        buffer.method_10797(this.graphId);
        buffer.method_53002(this.netId);
        buffer.method_52964(this.packetDeletesGraph);
        buffer.method_52964(this.fullWipe);
        if (this.packetDeletesGraph) {
            return;
        }
        DimensionPalette dimensions = new DimensionPalette();
        this.addedNodes.forEach((node, loc) -> dimensions.encode(((TrackNodeLocation)((Object)((Object)loc.getFirst()))).dimension));
        this.addedEdgePoints.forEach(ep -> ep.edgeLocation.forEach(loc -> dimensions.encode(loc.dimension)));
        DimensionPalette.PACKET_CODEC.encode((Object)buffer, (Object)dimensions);
        buffer.method_10804(this.removedNodes.size());
        this.removedNodes.forEach(arg_0 -> ((class_2540)buffer).method_10804(arg_0));
        buffer.method_10804(this.addedNodes.size());
        this.addedNodes.forEach((node, loc) -> {
            buffer.method_10804(node.intValue());
            ((TrackNodeLocation)((Object)((Object)loc.getFirst()))).send(buffer, dimensions);
            class_243.field_52694.encode((Object)buffer, (Object)((class_243)loc.getSecond()));
        });
        buffer.method_10804(this.addedEdges.size());
        this.addedEdges.forEach(pair -> {
            ((Couple)((Pair)pair.getFirst()).getFirst()).forEach(arg_0 -> ((class_2540)buffer).method_10804(arg_0));
            TrackMaterial.PACKET_CODEC.encode((Object)buffer, (Object)((TrackMaterial)((Pair)pair.getFirst()).getSecond()));
            BezierConnection turn = (BezierConnection)pair.getSecond();
            buffer.method_52964(turn != null);
            if (turn != null) {
                turn.write(buffer);
            }
        });
        buffer.method_10804(this.addedEdgePoints.size());
        this.addedEdgePoints.forEach(ep -> ep.write(buffer, dimensions));
        buffer.method_10804(this.removedEdgePoints.size());
        this.removedEdgePoints.forEach(arg_0 -> ((class_2540)buffer).method_10797(arg_0));
        buffer.method_10804(this.updatedEdgeData.size());
        for (Map.Entry<Couple<Integer>, Pair<Integer, List<UUID>>> entry : this.updatedEdgeData.entrySet()) {
            entry.getKey().forEach(arg_0 -> ((class_2540)buffer).method_53002(arg_0));
            Pair<Integer, List<UUID>> pair2 = entry.getValue();
            buffer.method_10804(pair2.getFirst().intValue());
            List<UUID> list = pair2.getSecond();
            buffer.method_10804(list.size());
            list.forEach(arg_0 -> ((class_2540)buffer).method_10797(arg_0));
        }
        buffer.method_10804(this.splitSubGraphs.size());
        this.splitSubGraphs.forEach((node, p) -> {
            buffer.method_10804(node.intValue());
            buffer.method_53002(((Integer)p.getFirst()).intValue());
            buffer.method_10797((UUID)p.getSecond());
        });
    }

    public void syncEdgeData(TrackNode node1, TrackNode node2, TrackEdge edge) {
        int groupType;
        Couple<Integer> key = Couple.create(node1.getNetId(), node2.getNetId());
        ArrayList<UUID> list = new ArrayList<UUID>();
        EdgeData edgeData = edge.getEdgeData();
        int n = edgeData.hasSignalBoundaries() ? 0 : (groupType = EdgeData.passiveGroup.equals(edgeData.getSingleSignalGroup()) ? 1 : 2);
        if (groupType == 2) {
            list.add(edgeData.getSingleSignalGroup());
        }
        for (TrackEdgePoint point : edgeData.getPoints()) {
            list.add(point.getId());
        }
        this.updatedEdgeData.put(key, Pair.of(groupType, list));
    }
}

