/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.fabric.smap;

import java.util.HashMap;
import java.util.Map;
import me.lucko.spark.fabric.smap.SourceDebugCache;
import me.lucko.spark.fabric.smap.SourceMap;
import org.jetbrains.annotations.Nullable;

public class SourceMapProvider {
    private final Map<String, SourceMap> cache = new HashMap<String, SourceMap>();

    @Nullable
    public SourceMap getSourceMap(String className) {
        if (this.cache.containsKey(className)) {
            return this.cache.get(className);
        }
        SourceMap smap = null;
        try {
            String value = SourceDebugCache.getSourceDebugInfo(className);
            if (value != null && (value = value.replaceAll("\r\n?", "\n")).startsWith("SMAP\n")) {
                smap = new SourceMap(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cache.put(className, smap);
        return smap;
    }
}

